/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSStart;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.swing.JOptionPane;

public final class DefaultExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private boolean recovering = false;
    private JLSStart jls = null;
    private Circuit circuit = null;
    private int[] extraSpace = new int[10000];

    public void setJLS(JLSStart jls) {
        this.jls = jls;
    }

    public void setCircuit(Circuit circ) {
        this.circuit = circ;
    }

    @Override
    public void uncaughtException(Thread t, Throwable th) {
        if (this.recovering) {
            System.exit(1);
        }
        this.recovering = true;
        if (th instanceof OutOfMemoryError) {
            this.extraSpace = null;
            System.gc();
            if (this.jls == null) {
                System.out.println("Not enough memory to simulate circuit");
                System.out.println("Run JLS again and give JVM more memory");
            } else {
                JOptionPane.showMessageDialog(null, "Not enough memory", "Error", 0);
                JOptionPane.showMessageDialog(null, "Run JLS again and give JVM more memory", "Warning", 2);
            }
            System.exit(1);
        } else if (this.jls == null) {
            this.saveTrace(th);
            System.out.println("UNEXPECTED INTERNAL ERROR!");
            System.out.println("JLS will create a file called JLSerror in the current folder/directory.");
            System.out.println("Please email it to pop@mtu.edu to report the error so it can be fixed.");
            System.exit(1);
        } else {
            this.saveTrace(th);
            String msg = "<html>UNEXPECTED INTERNAL ERROR! Try to save circuit(s).<p>JLS will create a file called JLSerror in the current folder/directory.<br>Please email it to pop@mtu.edu to report the error so it can be fixed.<br><br>Try restarting JLS using checkpoints of open circuits<br>(i.e., <i>file</i>.jls~, where <i>file</i> is the name of the open circuit)</html>";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
            System.exit(1);
        }
    }

    protected void saveTrace(Throwable th) {
        try {
            PrintWriter out = new PrintWriter("JLSerror");
            out.println("Please email this file to pop@mtu.edu");
            out.println("along with a short description of what");
            out.println("you were doing when the error occured.");
            out.println("Thanks.");
            out.printf("JLS %d.%d.%d %s\n", 4, 1, 7, "<p>[built on September 16, 2016 at 8:00 AM]");
            Properties prop = System.getProperties();
            prop.list(out);
            th.printStackTrace(out);
            if (this.circuit != null) {
                this.circuit.save(out);
            }
            out.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Can't create JLSerror file");
        }
    }
}

