/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.edit.SimpleEditor;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.JumpStart;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.elem.WireNet;
import edu.mtu.cs.jls.elem.bool.TruthTable;
import edu.mtu.cs.jls.elem.sm.StateMachine;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public final class Circuit
implements Printable {
    private String name = null;
    private String dir = "";
    private Set<Element> elements = new HashSet<Element>();
    private SubCircuit subElement = null;
    private Editor editor = null;
    private Set<String> namesUsed = new HashSet<String>();
    private SortedMap<String, JumpStart> starts = new TreeMap<String, JumpStart>();
    private boolean changed = false;
    private Set<Element> loadedElements = new HashSet<Element>();
    private Map<Integer, Element> elementMap = new HashMap<Integer, Element>();
    private static int lineNumber;

    public Circuit(String name) {
        this.name = name;
    }

    public String getDirectory() {
        return this.dir;
    }

    public void setDirectory(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void markChanged() {
        this.changed = true;
        if (this.subElement != null) {
            this.subElement.getCircuit().markChanged();
        }
        if (JLSInfo.sim != null) {
            JLSInfo.sim.stop();
        }
    }

    public void clear() {
        this.elements.clear();
        this.namesUsed.clear();
        this.starts.clear();
    }

    public void addElement(Element el) {
        this.elements.add(el);
        el.setCircuit(this);
    }

    public void remove(Element el) {
        this.elements.remove(el);
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    public boolean load(Scanner input) {
        lineNumber = 1;
        return this.load(input, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean load(Scanner input, int ln) {
        try {
            if (!input.hasNext()) {
                JLSInfo.loadError = "no header info";
                return false;
            }
            str = input.next();
            if (!str.equals("CIRCUIT")) {
                JLSInfo.loadError = "file does not start with CIRCUIT";
                return false;
            }
            if (!input.hasNext()) {
                JLSInfo.loadError = "no name for CIRCUIT";
                return false;
            }
            if (this.name.equals("")) {
                this.name = input.next();
            } else {
                input.next();
            }
            ++Circuit.lineNumber;
            while (true) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "no trailer";
                    return false;
                }
                str = input.next();
                if (str.equals("ENDCIRCUIT")) {
                    ++Circuit.lineNumber;
                    return true;
                }
                if (!str.equals("ELEMENT")) {
                    JLSInfo.loadError = "expecting ELEMENT";
                    return false;
                }
                if (!input.hasNext()) {
                    JLSInfo.loadError = "expecting ELEMENT type";
                    return false;
                }
                elementType = input.next();
                obj = null;
                try {
                    c = null;
                    try {
                        c = Class.forName("edu.mtu.cs.jls.elem." + elementType);
                    }
                    catch (ClassNotFoundException ex) {
                        c = null;
                    }
                    if (c == null) {
                        try {
                            c = Class.forName("edu.mtu.cs.jls.elem.bool." + elementType);
                        }
                        catch (ClassNotFoundException ex) {
                            c = null;
                        }
                    }
                    if (c == null) {
                        c = Class.forName("edu.mtu.cs.jls.elem.sm." + elementType);
                    }
                    var11_21 = cn = c.getConstructors();
                    var10_20 = cn.length;
                    var9_19 = 0;
                    while (true) {
                        if (var9_19 >= var10_20) {
                            if (obj == null) {
                                JLSInfo.loadError = "bad constructor";
                                return false;
                            }
                            break;
                        }
                        con = var11_21[var9_19];
                        if (con.getParameterTypes().length == 1 && con.getParameterTypes()[0].getName().equals("edu.mtu.cs.jls.Circuit")) {
                            obj = con.newInstance(new Object[]{this});
                        }
                        ++var9_19;
                    }
                }
                catch (ClassNotFoundException ex) {
                    JLSInfo.loadError = "bad element class name";
                    return false;
                }
                catch (InstantiationException ex) {
                    JLSInfo.loadError = "can't instantiate element object";
                    return false;
                }
                catch (IllegalAccessException ex) {
                    JLSInfo.loadError = "illegal access exception";
                    return false;
                }
                catch (InvocationTargetException ex) {
                    JLSInfo.loadError = "invocation target exception";
                    return false;
                }
                if (!(obj instanceof Element)) {
                    JLSInfo.loadError = "non-Element subclass";
                    return false;
                }
                newElement = obj;
                ++Circuit.lineNumber;
                loadOK = this.loadElement(newElement, input);
                if (!loadOK) {
                    JLSInfo.loadError = String.valueOf(JLSInfo.loadError) + "false from loadElement";
                    return false;
                }
                this.loadedElements.add(newElement);
            }
        }
        catch (Exception ex) {
            JLSInfo.loadError = "load exception: " + ex.getMessage();
            i = 0;
            if (true) ** GOTO lbl98
        }
        catch (Error er) {
            JLSInfo.loadError = "load error: " + er.getMessage();
            return false;
        }
        do {
            JLSInfo.loadError = String.valueOf(JLSInfo.loadError) + "\n" + ex.getStackTrace()[i].getFileName() + ex.getStackTrace()[i].getLineNumber();
            ++i;
lbl98:
            // 2 sources

        } while (i < ex.getStackTrace().length);
        return false;
    }

    public boolean loadElement(Element el, Scanner input) {
        while (input.hasNext()) {
            String value;
            if (input.hasNext("CIRCUIT")) {
                if (!(el instanceof SubCircuit)) {
                    JLSInfo.loadError = "expected SubCircuit";
                    return false;
                }
                Circuit subCirc = new Circuit("");
                if (!subCirc.load(input, 0)) {
                    JLSInfo.loadError = String.valueOf(JLSInfo.loadError) + "false from subCirc.load(input,0)";
                    return false;
                }
                SubCircuit sub = (SubCircuit)el;
                subCirc.setImported(sub);
                sub.setSubCircuit(subCirc);
                sub.setName(subCirc.getName());
                this.addName(subCirc.getName());
                if (subCirc.finishLoad(null)) continue;
                JLSInfo.loadError = String.valueOf(JLSInfo.loadError) + "false from subCir.finishLoad(null)";
                return false;
            }
            String type = input.next();
            if (type.equals("END")) {
                ++lineNumber;
                return true;
            }
            if (type.equals("int")) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "unexpected end";
                    return false;
                }
                String name = input.next();
                if (!input.hasNextInt()) {
                    JLSInfo.loadError = "expecting int value";
                    return false;
                }
                int value2 = input.nextInt();
                if (name.equals("id")) {
                    this.elementMap.put(value2, el);
                }
                el.setValue(name, value2);
                ++lineNumber;
                continue;
            }
            if (type.equals("long")) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "unexpected end";
                    return false;
                }
                String name = input.next();
                if (!input.hasNextLong()) {
                    JLSInfo.loadError = "expecting long value";
                    return false;
                }
                long value3 = input.nextLong();
                el.setValue(name, value3);
                ++lineNumber;
                continue;
            }
            if (type.equals("Int")) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "unexpected end";
                    return false;
                }
                String name = input.next();
                if (!input.hasNextBigInteger()) {
                    JLSInfo.loadError = "expecting BigInteger value";
                    return false;
                }
                BigInteger value4 = input.nextBigInteger();
                el.setValue(name, value4);
                ++lineNumber;
                continue;
            }
            if (type.equals("String")) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "unexpected end";
                    return false;
                }
                String name = input.next();
                String pattern = ".*";
                value = input.findInLine(pattern);
                if (value == null) {
                    JLSInfo.loadError = "null findInLine";
                    return false;
                }
                value = value.replace("\\\\", "\\");
                value = value.replace("\\\"", "\"");
                value = value.replace("\\n", "\n");
                value = value.substring(value.indexOf(34) + 1, value.lastIndexOf(34));
                el.setValue(name, value);
                ++lineNumber;
                continue;
            }
            if (type.equals("ref")) {
                if (!input.hasNext()) {
                    JLSInfo.loadError = "unexpected end";
                    return false;
                }
                String name = input.next();
                if (!input.hasNextInt()) {
                    JLSInfo.loadError = "expecting int value";
                    return false;
                }
                int value5 = input.nextInt();
                el.setValue(name, value5);
                ++lineNumber;
                continue;
            }
            if (type.equals("pair")) {
                if (!input.hasNextInt()) {
                    JLSInfo.loadError = "expecting int value";
                    return false;
                }
                int v1 = input.nextInt();
                if (!input.hasNextInt()) {
                    JLSInfo.loadError = "expecting int value";
                    return false;
                }
                int v2 = input.nextInt();
                el.setPair(v1, v2);
                ++lineNumber;
                continue;
            }
            if (type.equals("probe")) {
                if (!input.hasNextInt()) {
                    JLSInfo.loadError = "expecting int value";
                    return false;
                }
                int id = input.nextInt();
                String pattern = ".*";
                value = input.findInLine(pattern);
                if (value == null) {
                    JLSInfo.loadError = "null findInLine";
                    return false;
                }
                value = value.replace("\\\\", "\\");
                value = value.replace("\\\"", "\"");
                value = value.replace("\\n", "\n");
                value = value.substring(value.indexOf(34) + 1, value.lastIndexOf(34));
                if (!(el instanceof WireEnd)) {
                    JLSInfo.loadError = "expecting WireEnd";
                    return false;
                }
                WireEnd end = (WireEnd)el;
                end.setProbe(id, value);
                ++lineNumber;
                continue;
            }
            JLSInfo.loadError = "expecting item type";
            return false;
        }
        JLSInfo.loadError = "abnormal loadElement termination";
        return false;
    }

    public boolean finishLoad(Graphics g) {
        try {
            for (Element el : this.loadedElements) {
                if (el instanceof WireEnd) continue;
                el.init(g);
                this.elements.add(el);
            }
            LinkedList<WireEnd> ends = new LinkedList<WireEnd>();
            for (Element el : this.loadedElements) {
                if (!(el instanceof WireEnd)) continue;
                WireEnd end = (WireEnd)el;
                end.init(this);
                this.elements.add(end);
                ends.add(end);
            }
            while (!ends.isEmpty()) {
                LinkedList<WireEnd> visit = new LinkedList<WireEnd>();
                WireEnd end = (WireEnd)ends.remove();
                visit.add(end);
                WireNet net = new WireNet();
                HashSet<WireEnd> visited = new HashSet<WireEnd>();
                while (!visit.isEmpty()) {
                    WireEnd vend = (WireEnd)visit.remove();
                    ends.remove(vend);
                    visited.add(vend);
                    net.add(vend);
                    vend.setNet(net);
                    if (vend.isLoadTriState()) {
                        net.loadTriState();
                    }
                    if (vend.isAttached()) {
                        net.setBits(vend.getPut().getBits());
                        if (vend.getPut() instanceof Output) {
                            net.setInput();
                        }
                    }
                    for (Wire wire : vend.getWires()) {
                        WireEnd otherEnd = wire.getOtherEnd(vend);
                        if (visited.contains(otherEnd)) continue;
                        visit.add(otherEnd);
                        net.add(wire);
                        wire.setNet(net);
                    }
                }
            }
            this.loadedElements.clear();
        }
        catch (Exception ex) {
            JLSInfo.loadError = "finishLoad Exception " + ex;
            return false;
        }
        catch (Error er) {
            JLSInfo.loadError = "finishLoad Error " + er;
            return false;
        }
        return true;
    }

    public Rectangle getBounds() {
        Rectangle rect = new Rectangle();
        boolean firstTime = true;
        for (Element el : this.elements) {
            if (el instanceof Wire) continue;
            if (firstTime) {
                rect = el.getRect();
                firstTime = false;
                continue;
            }
            rect.add(el.getRect());
        }
        return rect;
    }

    public void save(PrintWriter output) {
        if (this.isImported()) {
            output.println("CIRCUIT " + this.subElement.getName());
        } else {
            output.println("CIRCUIT " + this.name);
        }
        int id = 0;
        for (Element el : this.elements) {
            el.setID(id);
            ++id;
        }
        for (Element el : this.elements) {
            el.save(output);
        }
        output.println("ENDCIRCUIT");
        this.changed = false;
    }

    public void draw(Graphics g, Set<Element> second, SimpleEditor ed) {
        if (this.loadedElements.size() > 0) {
            this.finishLoad(g);
            Rectangle rect = new Rectangle(0, 0, 1000, 1000);
            rect.add(this.getBounds());
            ed.setCircuitSize(rect.getSize());
        }
        for (Element el : this.elements) {
            if (!(el instanceof Wire) || second.contains(el)) continue;
            el.draw(g);
        }
        for (Element el : this.elements) {
            if (el instanceof Wire || second.contains(el)) continue;
            el.draw(g);
        }
        for (Element el : this.elements) {
            if (!(el instanceof Wire) || !second.contains(el)) continue;
            el.draw(g);
        }
        for (Element el : this.elements) {
            if (el instanceof Wire || !second.contains(el)) continue;
            el.draw(g);
        }
    }

    @Override
    public int print(Graphics g, PageFormat format, int pagenum) {
        Graphics2D gg = (Graphics2D)g;
        Circuit c = this;
        String nm = this.name;
        while (c.isImported()) {
            c = c.getSubElement().getCircuit();
            nm = String.valueOf(nm) + " in " + c.getName();
        }
        FontMetrics fm = gg.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int fontHeight = ascent + descent;
        Rectangle rect = this.getBounds();
        double width = format.getImageableWidth();
        double height = format.getImageableHeight();
        gg.translate(format.getImageableX(), format.getImageableY());
        gg.drawString(nm, 0, ascent);
        gg.translate(0, fontHeight * 2);
        height -= (double)(fontHeight * 2);
        double scale = 1.0;
        if ((double)rect.width > width) {
            scale = width / (double)rect.width;
        }
        if ((double)(rect.height + 6) > height) {
            scale = Math.min(scale, height / (double)(rect.height + 6));
        }
        gg.scale(scale, scale);
        gg.translate(-rect.x + 3, -rect.y + 3);
        this.draw(gg, new HashSet<Element>(), null);
        return 0;
    }

    public void addToBook(Book book, PageFormat format) {
        book.append(this, format);
        for (Element el : this.elements) {
            if (!(el instanceof StateMachine)) continue;
            StateMachine sm = (StateMachine)el;
            book.append(sm, format);
            Printable p = sm.makeOutSum();
            if (p == null) continue;
            book.append(p, format);
        }
        for (Element el : this.elements) {
            if (!(el instanceof TruthTable)) continue;
            TruthTable tt = (TruthTable)el;
            book.append(tt, format);
        }
        for (Element el : this.elements) {
            if (!(el instanceof SubCircuit)) continue;
            ((SubCircuit)el).getSubCircuit().addToBook(book, format);
        }
    }

    public void exportImage(String file) {
        Rectangle rect = this.getBounds();
        int border = 10;
        rect = new Rectangle(rect.x - border, rect.y - border, rect.width + 2 * border, rect.height + 2 * border);
        BufferedImage image = new BufferedImage(rect.width, rect.height, 1);
        Graphics2D g = image.createGraphics();
        AffineTransform translate = new AffineTransform();
        translate.translate(-rect.x, -rect.y);
        g.setTransform(translate);
        g.setColor(Color.white);
        g.fill(rect);
        this.draw(g, new HashSet<Element>(), null);
        try {
            ImageIO.write((RenderedImage)image, "JPEG", new File(file));
        }
        catch (Exception ex) {
            System.out.println("image write exception");
        }
        g.dispose();
        image.flush();
        image = null;
    }

    public void untouchPuts() {
        for (Element el : this.elements) {
            el.untouchPuts();
        }
    }

    public Element getElementByID(int id) {
        return this.elementMap.get(id);
    }

    public boolean addName(String name) {
        if (this.namesUsed.contains(name)) {
            return false;
        }
        this.namesUsed.add(name);
        return true;
    }

    public boolean hasName(String name) {
        return this.namesUsed.contains(name);
    }

    public void removeName(String name) {
        this.namesUsed.remove(name);
    }

    public void setImported(SubCircuit sub) {
        this.subElement = sub;
    }

    public boolean isImported() {
        return this.subElement != null;
    }

    public SubCircuit getSubElement() {
        return this.subElement;
    }

    public void removeAllProbes() {
        for (Element el : this.elements) {
            if (el instanceof Wire) {
                Wire wire = (Wire)el;
                wire.removeProbe();
                continue;
            }
            if (!(el instanceof SubCircuit)) continue;
            SubCircuit sub = (SubCircuit)el;
            sub.getSubCircuit().removeAllProbes();
        }
    }

    public void clearAllWatches() {
        for (Element el : this.elements) {
            if (el instanceof SubCircuit) {
                SubCircuit sub = (SubCircuit)el;
                sub.getSubCircuit().clearAllWatches();
                continue;
            }
            if (el.isUneditable()) continue;
            el.setWatched(false);
        }
    }

    public void resetAllDelays() {
        for (Element el : this.elements) {
            if (!(el instanceof LogicElement) || el.isUneditable()) continue;
            LogicElement logic = (LogicElement)el;
            logic.resetPropDelay();
        }
    }

    public boolean addJumpStart(String name, JumpStart start) {
        if (this.starts.containsKey(name)) {
            return false;
        }
        this.starts.put(name, start);
        return true;
    }

    public JumpStart getJumpStart(String name) {
        return (JumpStart)this.starts.get(name);
    }

    public Set<String> getJumpStartNames() {
        return this.starts.keySet();
    }

    public void removeJumpStart(String name) {
        this.starts.remove(name);
    }

    public void setEditor(Editor ed) {
        this.editor = ed;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + super.toString() + ")";
    }
}

