/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import java.math.BigInteger;
import java.util.BitSet;

public final class BitSetUtils {
    private BitSetUtils() {
    }

    public static BitSet Create(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be greater than zero (" + value + ")");
        }
        BitSet newBS = new BitSet();
        int highBit = (int)Math.ceil(Math.log(value + 1L) / Math.log(2.0));
        int index = 0;
        while (index < highBit) {
            long bit = (long)Math.pow(2.0, index);
            newBS.set(index, (bit & value) == bit);
            ++index;
        }
        return newBS;
    }

    public static BitSet Create(BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("value must be greater than zero (" + value + ")");
        }
        int numbits = value.bitLength() + 1;
        BitSet newBS = new BitSet(numbits);
        int index = 0;
        while (index < numbits) {
            if (value.testBit(index)) {
                newBS.set(index);
            }
            ++index;
        }
        return newBS;
    }

    public static String ToString(BitSet bs, int radix) {
        BigInteger bi = BigInteger.ZERO;
        int index = bs.nextSetBit(0);
        while (index >= 0) {
            bi = bi.setBit(index);
            index = bs.nextSetBit(index + 1);
        }
        return bi.toString(radix).toUpperCase();
    }

    public static String ToStringSigned(BitSet bs, int bits) {
        if (bits == 0) {
            return "unknown";
        }
        if (!bs.get(bits - 1)) {
            return BitSetUtils.ToString(bs, 10);
        }
        BitSet temp = (BitSet)bs.clone();
        temp.flip(0, bits);
        long val = BitSetUtils.ToLong(temp) + 1L;
        return "-" + Long.toString(val);
    }

    public static int ToInt(BitSet bs) {
        int pow = 1;
        int value = 0;
        int i = 0;
        while (i < bs.length()) {
            if (bs.get(i)) {
                value += pow;
            }
            pow *= 2;
            ++i;
        }
        return value;
    }

    public static long ToLong(BitSet bs) {
        long pow = 1L;
        long value = 0L;
        int i = 0;
        while (i < bs.length()) {
            if (bs.get(i)) {
                value += pow;
            }
            pow *= 2L;
            ++i;
        }
        return value;
    }

    public static BigInteger ToBigInteger(BitSet bs) {
        BigInteger value = BigInteger.ZERO;
        int i = 0;
        while (i < bs.length()) {
            if (bs.get(i)) {
                value = value.setBit(i);
            }
            ++i;
        }
        return value;
    }

    public static BitSet SumCarry(boolean carryIn, BitSet bs1, BitSet bs2) {
        BitSet sum = new BitSet();
        boolean carry = carryIn;
        int size = Math.max(bs1.size(), bs2.size());
        int index = 0;
        while (index < size) {
            boolean bit1 = bs1.get(index);
            boolean bit2 = bs2.get(index);
            if (bit1 && bit2 && carry) {
                carry = true;
                sum.set(index, true);
            } else if (bit1 && bit2 || (bit1 || bit2) && carry) {
                carry = true;
                sum.set(index, false);
            } else if (bs1.get(index) || bs2.get(index) || carry) {
                carry = false;
                sum.set(index, true);
            } else {
                carry = false;
                sum.set(index, false);
            }
            ++index;
        }
        if (carry) {
            sum.set(size);
        }
        return sum;
    }

    public static String toDisplay(BitSet value, int bits) {
        if (value == null) {
            return "HiZ";
        }
        String str = "0x" + BitSetUtils.ToString(value, 16);
        str = String.valueOf(str) + " (" + BitSetUtils.ToString(value, 10) + " unsigned, ";
        str = String.valueOf(str) + BitSetUtils.ToStringSigned(value, bits) + " signed)";
        return str;
    }
}

